<?php
class ApiController extends Controller{


	public $channel;
	public $subchannel;
	public $consumer;
	public $apikey;

	public function setValidate($channel,$subchannel,$consumer){
		if(isset($channel) && isset($subchannel) && isset($consumer)){
			//valido los headers que siempre vienen por defecto
					return true;
		}else{
			return false;
		}
	}


	 /**
	 * @api {get} /api/getExcludeRules/:paquete Obtener reglas de exclusion de  productos.

	 * @apiName Obtener reglas de exclusion de  productos.
	 * @apiGroup Paquetes
	 *
	 * @apiParam {String} paquete Paquete
	 *
	 * @apiHeader {String} Channel XXXX
	 * @apiHeader {String} SubChannel XXXX
	 * @apiHeader {String} Consumer XXXX
	 * @apiHeader {String} Apikey XXXX
	 *
	 * @apiSuccessExample {json} Success-Response:
	 *
	 *	[
		  {
			"IATA": "AF",
			"expire_date_to": "2016-07-30 00:00:00",
			"expire_date_from": "2016-07-11 00:00:00"
		  }
		]
	 */

	public function actionGetExcluderules($producto){
		header('Content-type: application/json');
		if(self::_validarapi_key($_SERVER['HTTP_APIKEY'])){
			if($producto!='' && $this->setValidate($_SERVER['HTTP_CHANNEL'],$_SERVER['HTTP_SUBCHANNEL'],$_SERVER['HTTP_CONSUMER']) == true){
				$channel=$_SERVER['HTTP_CHANNEL'];
				$subchannel=$_SERVER['HTTP_SUBCHANNEL'];
				$consumer=$_SERVER['HTTP_CONSUMER'];
				$query=Yii::app()->db->createCommand("SELECT iata_country_master.IATA,expire_date_to,expire_date_from FROM exclude_rules LEFT JOIN products ON Id_product=products.id LEFT JOIN iata_country_master ON id_IATA_Country_Master=iata_country_master.id WHERE products.id = (SELECT id FROM products where title = '$producto')")->queryall();
				if(count($query)>0){
					echo CJSON::encode($query);
				}else{
					throw new CHttpException(404,1);
				}
			}else{
				throw new CHttpException(404,0);
			}
		}else{
			throw new CHttpException(401,0);
		}
		Yii::app()->end();
	}

	/**
	 * @api {post} /sam/login Login de usuario
	 * @apiName Ingresar
	 * @apiGroup Usuario
	 *
	 * @apiParam {String} user Nombre de usuario.
	 * @apiParam {String} password Contraseña.
	 *
	 * @apiHeader {String} App XXXX
	 *
	 * @apiSuccessExample {json} Success-Response:
	 *
	 *     {
	 *		  "apikey": "c9ade8d6457c95977d71eb01360eae5c"
	 *		}
	 */
	public function actionLogin(){
		header('Content-type: application/json');
		$this->_checkAuth();
		Yii::app()->end();
	}
	/**
	 * @api {get} /api/getvalidatecheckoutid/checkoutid/:checkoutid Validar checkoutid
	 * @apiName Validar checkout
	 * @apiGroup Checkout
	 *
	 * @apiParam {Number} checkoutid Id del checkout.
	 *
	*
	 *
	 * @apiSuccessExample {json} Success-Response:
	 *
	 *     {
	 *	  "id_checkout": "10000001",
	 *	  "status": "Expire"
	 *		}
	*/
	public function actionGetvalidatecheckoutid($checkoutid){
		header('Content-type: application/json');
		if($checkoutid!=''){
			$checkout=Yii::app()->db->createCommand("SELECT checkout_control.expire_date,checkout_control.id_checkout FROM checkout_control WHERE checkout_control.id_checkout ='$checkoutid'")->queryRow();
			if($checkout>0){
				if($checkout['expire_date']>date("Y-m-d H:i:s")){
					echo CJSON::encode(array('id_checkout'=>$checkout['id_checkout'],'status'=>"Alive",'expire_date'=>$checkout['expire_date']));
				}else{
					echo CJSON::encode(array('id_checkout'=>$checkout['id_checkout'],'status'=>"Expire"));
				}
			}else{
				throw new CHttpException(401,1);
			}
		}else{
			throw new CHttpException(404,0);
		}
		Yii::app()->end();
	}

	/**
	 * @api {get} /api/getcheckoutid/:paquete Obtener checkoutid
	 * @apiName Obtener checkout
	 * @apiGroup Checkout
	 *
	 * @apiParam {String} paquete Nombre del paquete
	 *
	 * @apiHeader {String} Apikey XXXX
	 * @apiSuccessExample {json} Success-Response:
	 *
	 *     {
	 *	  "Producto": "Vuelos",
	 *	  "CheckoutId": 30000001
	 *	}
	*/
	public function actionCheckout($paquete){
		header('Content-type: application/json');
		if(self::_validarapi_key($_SERVER['HTTP_APIKEY'])){
			if($paquete!=''){
				$checkout=Yii::app()->db->createCommand("SELECT checkout.id as idCheckoutId, checkout.checkoutid AS CheckoutId,checkout.timeout FROM checkout LEFT JOIN products ON checkout.id_product = products.id WHERE products.title='$paquete'")->queryRow();
				if($checkout>0){
					$checkout_id=$checkout['CheckoutId']+1;
					$id_checkout=$checkout['idCheckoutId'];
					$time_out=date('Y-m-d H:i:s' ,strtotime( '+'.$checkout['timeout'].' minute',strtotime(date('Y-m-d H:i:s'))));
					Yii::app()->db->createCommand("update checkout set checkoutid='$checkout_id' where id='$id_checkout'")->query();
					Yii::app()->db->createCommand("INSERT INTO checkout_control( id_checkout, expire_date) VALUES ('$checkout_id' ,'$time_out')")->query();
					echo CJSON::encode(array('Producto'=>$paquete,'CheckoutId'=>$checkout_id,'expire_date'=>$time_out));
				}else{
					throw new CHttpException(404,1);
				}
			}else{
				throw new CHttpException(404,0);
			}
		}else{
			throw new CHttpException(404,0);
		}
		Yii::app()->end();
	}
	/**
	 * @api {get} /api/getproducts Listado de paquetes
	 * @apiName GetUser
	 * @apiGroup Paquetes
	 *
	 * @apiHeader {String} Channel XXXX
	 * @apiHeader {String} SubChannel XXXX
	 * @apiHeader {String} Consumer XXXX
	 * @apiHeader {String} Apikey XXXX
	 *
	 * @apiSuccessExample {json} Success-Response:
	 *
	 *[
	 * {
	 *	"title": "Vuelos",
	 *	"order": "2",
	 *	"start_in": "0"
	 * },
	 * {
	 *	"title": "Hoteles",
	 *	"order": "1",
	 *	"start_in": "1"
	 * },
	 * {
	 *	"title": "Paquetes",
	 *	"order": "3",
	 *	"start_in": "0"
	 *  }
	 *	]
	 */

	public function setSubchannelTitle($consumer,$subchannel){
		if(isset($consumer) && strtolower($_SERVER['HTTP_CONSUMER']) == 'iframe'){
			$subchannelTitle = strtolower(json_decode(self::getSubchannelTitle($subchannel))
			->subchannel);
		}else{
			$subchannelTitle = strtolower($_SERVER['HTTP_SUBCHANNEL']);
		}
		return $subchannelTitle;
	}

	public function actionGetProducts(){
		header('Content-type: application/json');
		if(self::_validarapi_key($_SERVER['HTTP_APIKEY'])){
			if($this->setValidate($_SERVER['HTTP_CHANNEL'],$_SERVER['HTTP_SUBCHANNEL'],$_SERVER['HTTP_CONSUMER']) == true){
				$channel=$_SERVER['HTTP_CHANNEL'];
				$subchannel=$_SERVER['HTTP_SUBCHANNEL'];
				$consumer=$_SERVER['HTTP_CONSUMER'];
				$query_add='';
				$subchannelTitle = $this->setSubchannelTitle($_SERVER['HTTP_CONSUMER'],$_SERVER['HTTP_SUBCHANNEL']);
				$query=Yii::app()->db->createCommand("SELECT products.title,search.order, search.anticipation_from_min_days, search.anticipation_to_max_days, search.max_search_months, search.landings_max_results_per_pages FROM search inner join products
				on products.id=search.id_product LEFT JOIN subchannels ON search.id_subchannel=subchannels.id
				LEFT JOIN channels ON search.id_channel=channels.id where channels.title = '$channel' AND subchannels.title = '$subchannelTitle'")->queryAll();
				if(count($query)>0){
					echo CJSON::encode($query);
				}else{
					throw new CHttpException(404,1);
				}
			}else{
				throw new CHttpException(404,0);
			}
		}else{
			throw new CHttpException(401,0);
		}
		Yii::app()->end();
	}
	/**
	 * @api {get} /api/getotc/:paquete Obtener otc
	 * @apiName Obtener otc
	 * @apiGroup Otc
	 *
	 * @apiParam {String} paquete Nombre del paquete
	 *
	 * @apiHeader {String} Channel XXXX
	 * @apiHeader {String} SubChannel XXXX
	 * @apiHeader {String} Consumer XXXX
	 * @apiHeader {String} Apikey XXXX
	 *
	 * @apiSuccessExample {json} Success-Response:
	 *
	 *	{
	 *	  "otc": "d1614350b3a94a4db1c235758e2d3a6f",
	 *	  "created_at": "2016-06-30 11:48:40",
	 *	  "expire": "2016-07-01 17:48:40"
	 *	}
	 */
public function actionGetotc($producto){
		header('Content-type: application/json');
			if(self::_validarapi_key($_SERVER['HTTP_APIKEY'])){
				if($producto!='' && $this->setValidate($_SERVER['HTTP_CHANNEL'],$_SERVER['HTTP_SUBCHANNEL'],$_SERVER['HTTP_CONSUMER']) == true){

					$checkout=Yii::app()->db->createCommand("SELECT otc_config.timeout,otc_config.id,otc_config.id_product FROM otc_config LEFT JOIN products on otc_config.id_product=products.id WHERE products.title='$producto'")->queryRow();

					if($checkout>0){

						$channel=$_SERVER['HTTP_CHANNEL'];
					 	$subchannel=$this->setSubchannelTitle($_SERVER['HTTP_CONSUMER'],$_SERVER['HTTP_SUBCHANNEL']);
						$created=date('Y-m-d H:i:s');
						$expire=date('Y-m-d H:i:s' ,strtotime( '+'.$checkout['timeout'].' minute',strtotime($created)));
						$otcToken = $channel.'|'.$subchannel.'|'.$expire;
						$otcToken = base64_encode($otcToken);

						$subchannelId=Yii::app()->db->createCommand("SELECT id FROM subchannels WHERE title = '$subchannel'")->queryRow();
						$channelId=Yii::app()->db->createCommand("SELECT id FROM  channels WHERE  title = '$channel'")->queryRow();
						$productoId = Yii::app()->db->createCommand("SELECT id FROM  products WHERE  title = '$producto'")->queryRow();
						$idotcconfig=$checkout['id'];
						$subchannelId = $subchannelId['id'];
						$channelId = $channelId['id'];
						$productoId = $productoId['id'];
						Yii::app()->db->createCommand("INSERT INTO otc(token,id_product,channel, subchannel,created_at, expire_date, id_otc_config) VALUES ('$otcToken','$productoId','$channelId','$subchannelId','$created','$expire','$idotcconfig')")->query();
						echo CJSON::encode(array('otc'=>$otcToken,'created_at'=>$created,'expire'=>$expire));
					}else{
						throw new CHttpException(404,1);
					}
				}else{
					throw new CHttpException(404,0);
				}
			}else{
				throw new CHttpException(401,3);
			}

		Yii::app()->end();
	}

	/**
	 * @api {get} /api/validapikey/:apikey Valida el apikey
	 * @apiName Validar el apikey
	 * @apiGroup Apikey
	 *
	 * @apiParam {String} apikey Apikey
	 *
	 *
	 * @apiSuccessExample {json} Success-Response:
	 *
	 *	{
	 *	  "status": "true",
	 *	}
	 */
	public function actionValidapikey($apikey){
		if(self::_validarapi_key($apikey)){
			echo json_encode(array('status'=>'true'));
		}else{
			echo json_encode(array('status'=>'false'));
		}
	}
	/**
	 * @api {post} /api/addreservation Agregar reserva
	 * @apiName Reserva
	 * @apiGroup Reserva
	 *
	 *	@apiParam {String} status  Valor esperado "Pending"
	 *	@apiParam {String} passenger  Valor esperado Nombre y Apellido ingresado como contacto en el checkout.
	 *	@apiParam {String} datebooking  Fecha de creacion del prebooking
	 *	@apiParam {String} book_code  Codigo de Prebooking del proveedor utilizado para confirmar y/o cancelar la prereserva
	 *	@apiParam {String} package  Titulo de Paquete.
	 *	@apiParam {Datetime} expire_date  Fecha y hora limite para confirmar la reserva
	 *	@apiParam {String} json  Json completo de la reserva
	 *	@apiParam {String} email_client  URL de email enviado al pasajero y alojado en elastichSearch
	 *	@apiParam {String} email_operation  URL de email enviado a operaciones y alojado en elastichSearch
	 *  @apiParam {Integer} id_providers  Id de proveedor dado de alta en ttsoffice
	 *
	 * @apiHeader {String} Channel XXXX
	 * @apiHeader {String} SubChannel XXXX
	 * @apiHeader {String} Consumer XXXX
	 * @apiHeader {String} Apikey XXXX
	 *
	 * @apiSuccessExample {json} Success-Response:
	 *
	 *     {
	 *		  "message": "Registrado Correctamente"
	 *		}
	 */
	public function actionAddreservation(){
		header('Content-type: application/json');
		$json = file_get_contents('php://input');
		$obj = json_decode($json);
		if(isset($obj->checkoutId)){
			$checkoutId = $obj->checkoutId;
		}else{
			$checkoutId ='';
		}
		if(isset($obj->status)){
			$status = $obj->status;
		}else{
			$status = '';
		}
		if(isset($obj->passenger)){
			$passenger = $obj->passenger;
		}else{
			$passenger = '';
		}
		if(isset($obj->datebooking)){
			$date = $obj->datebooking;
		}else{
			$date = '';
		}
		if(isset($obj->book_code)){
			$book_code= $obj->book_code;
		}else{
			$book_code = '';
		}
		if(isset($obj->package)){
			$package= $obj->package;
		}else{
			$package = '';
		}
		if(isset($obj->expire_date)){
			$expire_date = $obj->expire_date;
		}else{
			$expire_date = '';
		}
		if(isset($obj->json)){
			$json = $obj->json;
		}else{
			$json = '';
		}
		if(isset($obj->email_client)){
			$email_client = $obj->email_client;
		}else{
			$email_client = '';
		}
		if(isset($obj->email_operation)){
			$email_operation = $obj->email_operation;
		}else{
			$email_operation = '';
		}
		if(isset($obj->id_providers)){
			$id_providers=$obj->id_providers;
		}else{
			$id_providers = '';
		}
		if(self::_validarapi_key($_SERVER['HTTP_APIKEY'])){
			if($this->setValidate($_SERVER['HTTP_CHANNEL'],$_SERVER['HTTP_SUBCHANNEL'],$_SERVER['HTTP_CONSUMER']) == true){
				if($checkoutId=='' || $id_providers=='' || $email_operation=='' ||  $email_client=='' || $json=='' || $expire_date=='' || $package=='' || $book_code=='' || $date=='' || $passenger=='' || $status=='' || $checkoutId==''){
					throw new CHttpException(400,1);
				}else{
					$id_channel=$_SERVER['HTTP_CHANNEL'];
					$id_subchannel=$_SERVER['HTTP_SUBCHANNEL'];
					$consumer=$_SERVER['HTTP_CONSUMER'];
					$validate_consumer=self::consumer($consumer);
					Yii::app()->db->createCommand("INSERT INTO booking( checkoutId,id_providers, id_channel, id_subchannel, status, passenger, date, book_code, package, expire_date, json, email_client, email_operation,consumer) VALUES ( '$checkoutId',$id_providers,(SELECT id FROM channels where title='$id_channel'),(SELECT id FROM subchannels where $validate_consumer = '$id_subchannel'), '$status', '$passenger', '$date', '$book_code', '$package', '$expire_date', '$json', '$email_client', '$email_operation','$consumer')")->query();
					echo CJSON::encode(array('message'=>'Registrado Correctamente'));
				}
			}else{
				throw new CHttpException(404,1);
			}
		}else{
			throw new CHttpException(404,0);
		}
		Yii::app()->end();
	}

	public function actionPublish(){
		header('Content-type: application/json');
		ini_set('memory_limit', '6G');
		$json = file_get_contents('php://input');
		$content=json_decode($json);
		if($json!=''){
			//a probar
			if(!is_dir('tmp')){
				mkdir('tmp');
			}
			if(!is_dir('tmp/all')){
				mkdir('tmp/all');
			}
			//a probar
			if(isset($content->subchannel) || isset($content->channel)){
				if(!is_dir('tmp/'.$content->channel_folder)){
					mkdir('tmp/'.$content->channel_folder);
				}
				if(!is_dir('tmp/'.$content->channel_folder.'/'.$content->subchannel_folder)){
					mkdir('tmp/'.$content->channel_folder.'/'.$content->subchannel_folder);
				}
				$file = 'tmp/'.$content->channel_folder.'/'.$content->subchannel_folder.'/'.$content->name.'.json';
				$fh = fopen($file, 'w');
				fwrite($fh, json_encode(array("name"=>$content->name,"data"=>$content->data,"subchannel"=>$content->subchannel,"channel"=>$content->channel,"publication_date"=>$content->publication_date)));
			}else{
				$file = 'tmp/all/'.$content->name.'.json';
				$fh = fopen($file, 'w');
				fwrite($fh, json_encode(array("name"=>$content->name,"data"=>$content->data,"publication_date"=>$content->publication_date)));
			}
			fclose($fh);
			echo json_encode(array('Publicado correctamente'));
		}else{
			echo json_encode(array('Falta el contenido'));
		}
		Yii::app()->end();
	}

	public function actionPublishdb(){
		 date_default_timezone_set('America/Buenos_Aires');
		$transaction=Yii::app()->db->beginTransaction();
		try{
			$this->listar_directorios_ruta(Yii::app()->params['serverUrl']);
			$this->listar_directorios_ruta(Yii::app()->params['serverUrl']."/all");
		}catch(Exception $e){
			$transaction->rollback();
		}
		$transaction->commit();
	}
	public function listar_directorios_ruta($ruta){
		ini_set('memory_limit', '6G');
		set_time_limit(0);
	        if (is_dir($ruta)) {
	            if ($dh = opendir($ruta)) {
	                while (($file = readdir($dh)) !== false) {
	                    if ($file!="." && $file!=".."){
	                        if(strpos($file, '.json')){
	                            $fichero = file_get_contents($ruta.'/'.$file);
	                            $fichero=json_decode($fichero);
	                            $fecha =$fichero->publication_date;
	                            $nuevafecha = strtotime ( '+30 minute' , strtotime ( $fecha ) ) ;
	                            $nuevafecha = date ( "Y-m-d H:i:s" , $nuevafecha );
	                            if ($this->check_in_range($fichero->publication_date, $nuevafecha, date("Y-m-d H:i:s"))) {
	                                if(isset($fichero->subchannel) || isset($fichero->channel)){
	                                    $table=$fichero->name;
	                                    $channel=$fichero->channel;
	                                    if($fichero->name=='subchannels'){
	                                        $subchannel=$fichero->subchannel;
	                                        $query=Yii::app()->db->createCommand("delete from $table where id_channel=$channel and id=$subchannel")->query();
	                                    }else{
	                                        $subchannel=$fichero->subchannel;
	                                        $query=Yii::app()->db->createCommand("delete from $table where id_channel=$channel and id_subchannel=$subchannel")->query();
	                                    }
	                                    foreach($fichero->data as $datos){
	                                        $datos =(array) $datos;
	                                        //$columns = implode(", ",array_keys($datos));
	                                        $columns = '';
	                                        $values='';
	                                        foreach(array_values($datos) as $value){
	                                            if($value==''){
	                                                $values.="NULL,";
	                                            }else{
	                                                $values.="'".$value."',";
	                                            }
	                                        }
	                                        foreach(array_keys($datos) as $value){
	                                            $columns.=$table.'.'.$value.',';
	                                        }
	                                        $values=substr($values,0,-1);
	                                        $columns=substr($columns,0,-1);
	                                        Yii::app()->db->createCommand("INSERT INTO $table ($columns) VALUES ($values)")->query();
	                                    }
	                                }else{
	                                    $table=$fichero->name;
	                                    $query=Yii::app()->db->createCommand("delete from $table")->query();
	                                    foreach($fichero->data as $datos){
	                                        $datos =(array) $datos;
	                                        //$columns = implode(", ",array_keys($datos));
	                                        $columns = '';
	                                        $values='';
	                                        foreach(array_values($datos) as $value){
	                                            if($value==''){
	                                                $values.="NULL,";
	                                            }else{
	                                                $values.="'".$value."',";
	                                            }
	                                        }
	                                        foreach(array_keys($datos) as $value){
	                                            $columns.=$table.'.'.$value.',';
	                                        }
	                                        $columns=substr($columns,0,-1);
	                                        $values=substr($values,0,-1);
	                                        Yii::app()->db->createCommand("INSERT INTO $table ($columns) VALUES ($values)")->query();
	                                    }
	                                }
	                                echo "Cambios procesados.";
	                                rename($ruta.'/'.$file, $ruta.'/'.substr_replace($file , 'old', strrpos($file , '.') +1));
	                            }else{
	                                echo "No hay cambios.";
	                            }


	                        }
	                        self::listar_directorios_ruta("$ruta/$file");

	                    }

	                }
	                closedir($dh);
	            }
	        }
	    }



	public function _checkAuth(){
		// Check headers
		if((!isset($_SERVER['HTTP_APP'])) or (!isset($_POST['user'])) or (!isset($_POST['pass'])) ) {
			// Error: Unauthorized
			throw new CHttpException(404,0);
		}
		$username = $_POST['user'];
		$password = $_POST['pass'];
		
		// Find the user
		$user=Yii::app()->db->createCommand("select pass,id from user_services where user='$username' and enabled=1")->queryRow();
		if(count($user)>0){
			if(self::_validarpass($password,$user['pass'])){
				$id_user=$user['id'];
				$user_app=Yii::app()->db->createCommand("select MIN(NULLIF(master_api.rules_time, 0)) as tiempo from user_services inner join api_user on user_services.id=api_user.id_user_services inner join master_api on master_api.id=api_user.id_master_api  where user_services.id=$id_user and user_services.enabled=1 and api_user.enabled=1 and master_api.enabled=1 and master_api.rules_time is not null GROUP BY user_services.id")->queryRow();
				if($user_app){
					$api_key=md5(date("Y-m-d H:i:s").$user['id']);
					if($user_app['tiempo']==NULL){
						$desde='NULL';
						$hasta='NULL';
						$valida_vigencia=0;
						$apikey_query=Yii::app()->db->createCommand("Insert into api_key (api_key,valid_expire,enabled,id_user_services)values('$api_key','$valida_vigencia','1','$id_user')")->query();
					}else{
						$desde=date("Y-m-d H:i:s");
						$hasta=date('Y-m-d H:i:s' ,strtotime( '+'.$user_app['tiempo'].' minute',strtotime($desde)));
						$valida_vigencia=1;
						$apikey_query=Yii::app()->db->createCommand("Insert into api_key (api_key,expire_date_from,expire_date_to,valid_expire,enabled,id_user_services)values('$api_key','$desde','$hasta','$valida_vigencia','1','$id_user')")->query();
					}
					echo CJSON::encode(array('apikey'=>$api_key));

				}else{
					throw new CHttpException(404,0);
				}
			}else{
				throw new CHttpException(404,2);
			}
		}else{
			throw new CHttpException(404,2);
		}
	}

    private function _validarpass($passPlana, $passHash){
    	$md5 = md5($passPlana);
    	if($md5 == $passHash){
    		return true;
    	}else{
    		return false;
    	}
        //return password_verify($passPlana, $passHash);
    }

	private function check_in_range($start_date, $end_date, $evaluame) {
		$start_ts = strtotime($start_date);
		$end_ts = strtotime($end_date);
		$user_ts = strtotime($evaluame);
		return (($user_ts >= $start_ts) && ($user_ts <= $end_ts));
	}

    private function consumer($consumer='api'){
       if(strtolower($consumer)=='api'){
		   return 'subchannels.title';
	   }else{
		   return 'subchannels.url';
	   }
    }

	private function _validarapi_key($api_key){
		if(isset($api_key)){
			$query=Yii::app()->db->createCommand("Select api_key.valid_expire,api_key.expire_date_to from api_key inner join user_services on api_key.id_user_services=user_services.id where api_key.api_key='$api_key' and api_key.enabled=1 and user_services.enabled=1")->queryRow();

			if($query){
				if($query['valid_expire']==1){
					if(date("Y-m-d H:i:s")>$query['expire_date_to']){
						return false;
					}else{
						return true;
					}
				}else{
					return true;
				}
			}else{
				return false;
			}
			return true;
		}else{
			return false;
		}

	}

	public function actionError(){
		header('Content-type: application/json');
		$error=Yii::app()->errorHandler->error;
		$codes = array(
			200 => array('OK'),
			400 => array('Bad Request','Faltan alguno de los parametros requeridos'),
			401 => array('Unauthorized','Usuario inhabilitado','Usuario o contraseña fallidos','Sesion expirada'),
			402 => array('Payment Required'),
			403 => array('Forbidden'),
			404 => array('Not Found','No se encontraron resultados'),
			500 => array('Internal Server Error'),
			501 => array('Not Implemented'),
		);
		if(!is_numeric ($error['message'])){
			$result=$error['message'];
		}else{
			$result=$codes[$error['code']][$error['message']];
		}
		echo CJSON::encode(array('code'=>$error['code'],'exception'=>$result));
		Yii::app()->end();
	}


/**
	 * @api {get} /api/GetAdminrules/:producto Obtener reglas de administracion.

	 * @apiName  GetAdminrules
	 * @apiGroup Paquetes
	 *
	 * @apiParam {String} producto Producto
	 *
	 * @apiHeader {String} Channel XXXX
	 * @apiHeader {String} SubChannel XXXX
	 * @apiHeader {String} Consumer XXXX
	 * @apiHeader {String} Apikey XXXX
	 *
	 * @apiSuccessExample {json} Success-Response:
	 *
	 *
{
       "channel": "Site",
       "subchannel": "TTSDesa",
       "product": "Paquetes",
       "admin_notifications": {
           "admin_alert": {
               "alerts_server_name": "Alertas",
               "alerts_server_host": "181.119.20.114",
               "alerts_server_port": "21",
               "alerts_server_ssl": "1",
               "alerts_user": "sendmail@ttsviajes.com",
               "alerts_pass": "tts3563",
               "alerts_subject_patterns": "{channel},{subchannel},{titulo}",
               "alerts_to": "pruebatesting@ttsviajes.com"
           },
           "admin_sale": {
               "sale_server_name": "Alertas",
               "sale_server_host": "181.119.20.114",
               "sale_server_port": "21",
               "sale_server_ssl": "1",
               "sale_user": "sendmail@ttsviajes.com",
               "sale_pass": "tts3563",
               "sale_show_as": "pruebatesting@ttsviajes.com",
               "sale_to": "pruebatesting@ttsviajes.com"
           }
       },
       "admin_landings": {
           "landings_order_price": "asc",
           "landings_order_departure": "asc",
           "landings_telephone_sales": "asc",
           "landings_max_results_per_pages": "5",
           "facets": [
               {
                   "title": "filtro de bus",
                   "is_facets": "0"
               }
           ]
       }
   }
	 */

	public function actionGetAdminOffertsrules($producto){
		header('Content-type: application/json');
		if(self::_validarapi_key($_SERVER['HTTP_APIKEY'])){
			if($this->setValidate($_SERVER['HTTP_CHANNEL'],$_SERVER['HTTP_SUBCHANNEL'],$_SERVER['HTTP_CONSUMER'])){
				$channel=$_SERVER['HTTP_CHANNEL'];
				$subchannel=$_SERVER['HTTP_SUBCHANNEL'];
				$consumer=$_SERVER['HTTP_CONSUMER'];
				$validate_consumer=self::consumer($consumer);
				$query_add='';
				$query=Yii::app()->db->createCommand("
					SELECT
						offers_product.id,
						channels.title channel,
						subchannels.title subchannel,
						products.title product,
						server_alert.title as alerts_server_name,
						server_alert.host_server_mail as alerts_server_host,
						server_alert.Port as alerts_server_port,
						server_alert.ssl as alerts_server_ssl,
						offers_product.alerts_user,
						offers_product.alerts_pass,
						offers_product.alerts_show_as,
						offers_product.alerts_subject_patterns,
						offers_product.alerts_to,
						server_sales.title as sale_server_name,
						server_sales.host_server_mail as sale_server_host,
						server_sales.Port as sale_server_port,
						server_sales.ssl as sale_server_ssl,
						offers_product.sale_user,
						offers_product.sale_pass,
						offers_product.sale_show_as,
						offers_product.sale_to
					FROM offers_product
					LEFT JOIN channels ON channels.id = offers_product.id_channel
					LEFT JOIN subchannels ON subchannels.id = offers_product.id_subchannel
					LEFT JOIN products ON products.id = offers_product.id_product
					LEFT JOIN email_server as server_alert ON offers_product.id_email_server_alerts = server_alert.id
					LEFT JOIN email_server as server_sales ON offers_product.id_email_server_sales = server_sales.id
					WHERE offers_product.enabled = 1
					AND server_alert.enabled = 1
					AND server_sales.enabled = 1
					AND products.title = '$producto'
					AND channels.title = '$channel'
					AND $validate_consumer LIKE '%$subchannel%'")->queryAll();
				$admin_rules = [];
				$admin_rule = [];
				$admin_notifications = [];
				$admin_alert = [];
				$admin_sale = [];
				if(count($query)>0){
					foreach ($query as $key => $value) {
							$admin_rule['channel'] = $value['channel'];
							$admin_rule['subchannel'] = $value['subchannel'];
							$admin_rule['product'] = $value['product'];

							$admin_alert['alerts_server_name'] = $value['alerts_server_name'];
							$admin_alert['alerts_server_host'] = $value['alerts_server_host'];
							$admin_alert['alerts_server_port'] = $value['alerts_server_port'];
							$admin_alert['alerts_server_ssl'] = $value['alerts_server_ssl'];
							$admin_alert['alerts_user'] = $value['alerts_user'];
							$admin_alert['alerts_pass'] = $value['alerts_pass'];
							$admin_alert['alerts_show_as'] = $value['alerts_show_as'];
							$admin_alert['alerts_subject_patterns'] = $value['alerts_subject_patterns'];
							$admin_alert['alerts_to'] = $value['alerts_to'];

							$admin_sale['sale_server_name'] = $value['sale_server_name'];
							$admin_sale['sale_server_host'] = $value['sale_server_host'];
							$admin_sale['sale_server_port'] = $value['sale_server_port'];
							$admin_sale['sale_server_ssl'] = $value['sale_server_ssl'];
							$admin_sale['sale_user'] = $value['sale_user'];
							$admin_sale['sale_pass'] = $value['sale_pass'];
							$admin_sale['sale_show_as'] = $value['sale_show_as'];
							$admin_sale['sale_to'] = $value['sale_to'];

							$admin_notifications['admin_alert'] = $admin_alert;
							$admin_notifications['admin_sale'] = $admin_sale;
							$admin_rule['admin_notifications'] = $admin_notifications;
							array_push($admin_rules, $admin_rule);
					}

					echo CJSON::encode($admin_rules[0]);
				}else{
					throw new CHttpException(404,1);
				}
			}else{
				throw new CHttpException(404,0);
			}
		}else{
			throw new CHttpException(401,3);
		}
		Yii::app()->end();
	}

	/**
	 * @api {get} /api/GetBusinessexceptions/:producto Obtener reglas de excepciones de negocio.

	 * @apiName  GetBusinessexceptions
	 * @apiGroup Paquetes
	 *
	 * @apiParam {String} producto Producto
	 *
	 * @apiHeader {String} Channel XXXX
	 * @apiHeader {String} SubChannel XXXX
	 * @apiHeader {String} Consumer XXXX
	 * @apiHeader {String} Apikey XXXX
	 *
	 * @apiSuccessExample {json} Success-Response:
	 *
	 *	[
		  {
		    "title": "<p><strong>testestset</strong></p>\r\n",
		    "description": "testset",
		    "action": "testset",
		    "producto": "Hoteles"
		  }
		]
	 */

	public function actionGetBusinessexceptions($producto){
		header('Content-type: application/json');
		if(self::_validarapi_key($_SERVER['HTTP_APIKEY'])){
			if($producto!='' && $this->setValidate($_SERVER['HTTP_CHANNEL'],$_SERVER['HTTP_SUBCHANNEL'],$_SERVER['HTTP_CONSUMER'])){
				$channel=$_SERVER['HTTP_CHANNEL'];
				$subchannel=$_SERVER['HTTP_SUBCHANNEL'];
				$consumer=$_SERVER['HTTP_CONSUMER'];
				$query=Yii::app()->db->createCommand("	SELECT be.title, be.description, be.action, p.title producto
														FROM business_exceptions be
														LEFT JOIN products p ON p.id = be.id_product
														WHERE p.title = '$producto'")->queryall();
				if(count($query)>0){
					echo CJSON::encode($query);
				}else{
					throw new CHttpException(404,1);
				}
			}else{
				throw new CHttpException(404,0);
			}
		}else{
			throw new CHttpException(401,3);
		}

		Yii::app()->end();
	}

	/**
	 * @api {get} /api/Getpollhash/:polltype Obtener reglas de excepciones de negocio.

	 * @apiName  Getpollhash
	 * @apiGroup Encuestas
	 *
	 * @apiParam {String} polltype PollType
	 *
	 * @apiHeader {String} Apikey XXXX
	 *
	 * @apiSuccessExample {json} Success-Response:
	 *
	 *	{
		    "type": "TestDeEncuestaDeSatisfacccion",
		    "hash": "asdasd as  asds aasa aa aaa asa asad s adsa d"
		  }
	 */

	public function actionGetpollhash($pollname){
		header('Content-type: application/json');
		if(isset($_SERVER['HTTP_APIKEY'])){
			if(self::_validarapi_key($_SERVER['HTTP_APIKEY'])){
					$query=Yii::app()->db->createCommand("	SELECT type,hash from polls where name = '$pollname'")->queryall();
					if(count($query)>0){
						echo CJSON::encode($query[0]);
					}else{
						throw new CHttpException(404,1);
					}
			}else{
				throw new CHttpException(401,3);
			}
		}else{
			throw new CHttpException(401,0);
		}
		Yii::app()->end();
	}

	/**
	 * @api {get} /api/Getenabledproducts Listado de productos disponibles
	 * @apiName Getenabledproducts
	 * @apiGroup Paquetes
	 *
	 *
	 * @apiSuccessExample {json} Success-Response:
	 *[
    {
        "id": "1",
        "title": "Vuelos",
        "reactive_enabled": "1"
    },
    {
        "id": "2",
        "title": "Hoteles",
        "reactive_enabled": "1"
    },
    {
        "id": "3",
        "title": "Paquetes",
        "reactive_enabled": "0"
    },
    {
        "id": "4",
        "title": "Autos",
        "reactive_enabled": "1"
    },
    {
        "id": "5",
        "title": "Asistencias",
        "reactive_enabled": "1"
    },
    {
        "id": "6",
        "title": "Cruceros",
        "reactive_enabled": "1"
    },
    {
        "id": "7",
        "title": "Buses",
        "reactive_enabled": "1"
    }
]

	 */
	public function actionGetenabledproducts(){
		header('Content-type: application/json');
		$query=Yii::app()->db->createCommand("SELECT id,title,reactive_enabled FROM products WHERE enabled = 1")->queryAll();
		if(count($query)>0){
			echo CJSON::encode($query);
		}else{
			throw new CHttpException(404,1);
		}
		Yii::app()->end();
	}

		/**
	 * @api {get} /api/Reactiveon/:producto Prende un producto
	 * @apiName Reactiveon
	 * @apiGroup Paquetes
	 *
	 * @apiParam {String} producto Producto
	 *
	 * @apiHeader {String} Channel XXXX
	 * @apiHeader {String} SubChannel XXXX
	 * @apiHeader {String} Consumer XXXX
	 * @apiHeader {String} Apikey XXXX
	 *
	 * @apiSuccessExample {json} Success-Response:
	 *
	 *	{
	 *	  "status": "true"
	 *	}
	 */
	public function actionReactiveon($producto){
		header('Content-type: application/json');
		if(self::_validarapi_key($_SERVER['HTTP_APIKEY'])){
			if($this->setValidate($_SERVER['HTTP_CHANNEL'],$_SERVER['HTTP_SUBCHANNEL'],$_SERVER['HTTP_CONSUMER'])){
				$channel=$_SERVER['HTTP_CHANNEL'];
				$subchannel=$_SERVER['HTTP_SUBCHANNEL'];
				$consumer=$_SERVER['HTTP_CONSUMER'];
				$validate_consumer=self::consumer($consumer);
				$query_add='';
				try{
					$query=Yii::app()->db->createCommand("UPDATE products SET reactive_enabled = 1 WHERE title = '$producto'")->query();
					echo CJSON::encode(array('status'=>'true'));
				}catch(Exception $ex){
					throw new CHttpException(404,1);
				}
			}else{
				throw new CHttpException(404,0);
			}
		}else{
			throw new CHttpException(401,3);
		}
		Yii::app()->end();
	}

	/**
	 * @api {get} /api/Reactiveoff/:producto Apaga un producto
	 * @apiName Reactiveoff
	 * @apiGroup Paquetes
	 *
	 * @apiParam {String} producto Producto
	 *
	 * @apiHeader {String} Channel XXXX
	 * @apiHeader {String} SubChannel XXXX
	 * @apiHeader {String} Consumer XXXX
	 * @apiHeader {String} Apikey XXXX
	 *
	 * @apiSuccessExample {json} Success-Response:
	 *
	 *	{
	 *	  "status": "true"
	 *	}
	 */
	public function actionReactiveoff($producto){
		header('Content-type: application/json');
			if(self::_validarapi_key($_SERVER['HTTP_APIKEY'])){
				if($this->setValidate($_SERVER['HTTP_CHANNEL'],$_SERVER['HTTP_SUBCHANNEL'],$_SERVER['HTTP_CONSUMER'])){
					$channel=$_SERVER['HTTP_CHANNEL'];
					$subchannel=$_SERVER['HTTP_SUBCHANNEL'];
					$consumer=$_SERVER['HTTP_CONSUMER'];
					$validate_consumer=self::consumer($consumer);
					$query_add='';
					try{
						$query=Yii::app()->db->createCommand("UPDATE products SET reactive_enabled = 0 WHERE title = '$producto'")->query();
						echo CJSON::encode(array('status'=>'true'));
					}catch(Exception $ex){
						throw new CHttpException(404,1);
					}
				}else{
					throw new CHttpException(404,0);
				}
			}else{
				throw new CHttpException(401,3);
			}
		Yii::app()->end();
	}

	/**
	 * @api {get} /api/gtreactiveoff/:producto Busca si el producto esta apagado o no
	 * @apiName Getreactiveoff
	 * @apiGroup Paquetes
	 *
	 * @apiParam {String} producto Producto
	 *
	 * @apiHeader {String} Channel XXXX
	 * @apiHeader {String} SubChannel XXXX
	 * @apiHeader {String} Consumer XXXX
	 * @apiHeader {String} Apikey XXXX
	 *
	 * @apiSuccessExample {json} Success-Response:
	 *
	 *	{
	 *	  "status": "off"
	 *	}
	 */
	public function actionGetreactiveoff($producto){
		header('Content-type: application/json');
		if(self::_validarapi_key($_SERVER['HTTP_APIKEY'])){
			if($this->setValidate($_SERVER['HTTP_CHANNEL'],$_SERVER['HTTP_SUBCHANNEL'],$_SERVER['HTTP_CONSUMER'])){
				$channel=$_SERVER['HTTP_CHANNEL'];
				$subchannel=$_SERVER['HTTP_SUBCHANNEL'];
				$consumer=$_SERVER['HTTP_CONSUMER'];
				$validate_consumer=self::consumer($consumer);
				$query_add='';
				try{
					$query=Yii::app()->db->createCommand("SELECT reactive_enabled from products WHERE title = '$producto'")->query();
					$json = CJSON::encode($query);
					$json = json_decode($json,true);
					if($json[0]['reactive_enabled'] == 0){
						echo json_encode(array('status'=>'off'));
					}else{
						echo json_encode(array('status'=>'on'));
					}
				}catch(Exception $ex){
					throw new CHttpException(404,1);
				}
			}else{
				throw new CHttpException(404,0);
			}
		}else{
			throw new CHttpException(401,3);
		}

	Yii::app()->end();
	}


	public function actionInsertgift(){
			$json = file_get_contents('php://input');
			$obj = json_decode($json,true);
			$regalo =$obj["regalo"];
			$lista = $obj["lista"];
			$usuario = $obj["usuario"];
			$mail_user = $obj["mail_user"];
			$fecha = $obj["fecha"];
			$comentariosvendedor = $obj["cometariovendedor"];
			$mensajenovios =$obj["mensajenovios"];
			$novios =$obj["novios"];
			$telefono = $obj["telefono"];


			$query = Yii::app()->db2->createCommand("INSERT INTO regalosbk (regalo, lista, usuario, mailuser, fecha,
				comentariosvendedor, mensajenovios, novios, telefono)
			VALUES ( '$regalo', '$lista', '$usuario', '$mail_user', '$fecha',
				'$comentariosvendedor', '$mensajenovios', '$novios', '$telefono')")->query();
				//print_r('inserte');
			$id=Yii::app()->db2->lastInsertID;
			if (!empty($id))
				{return $id;}
	}

	public function actionInsertbooking(){
			$json = file_get_contents('php://input');
			$obj = json_decode($json,true);
			$username = 'NULL';
			//print_r($obj["body"]);die;
			$nombre = $obj["body"]["nombre"];
			$apellido = $obj["body"]["apellido"];
			$numero = $obj["body"]["telefono"];
			$mail = $obj["body"]["email"];
			$url = $obj["body"]["url"];
			$fecha = $obj["body"]["fecha"];
			$noches = $obj["body"]["noches"];
			$categoriahotel = $obj["body"]["categoriahotel"];
			$hotel = $obj["body"]["hotel"];
			$producto = $obj["body"]["destino"];
			if(empty($obj["body"]["pagotarjeta"])||empty($obj["body"]["pagobanco"])){
				$formapago = "";
			}else{
				$formapago ='Tarjeta '.$obj["body"]["pagotarjeta"].' Banco '.$obj["body"]["pagobanco"];
			}
if(empty($obj["body"]["vendedor"])||empty($obj["body"]["vendedor"])){
				$username = 'NULL';
			}else{
				$username= $obj["body"]["vendedor"];

$query=Yii::app()->db2->createCommand("SELECT user,id from empleados WHERE user = '$username' limit 1")->query();
                    
                    
					$json = CJSON::encode($query);
					$json = json_decode($json,true);
if(!empty($json[0]['id'])){$username=$json[0]['id'];}else{$username='NULL';}
			}
			$comments = $obj["body"]["consulta"];
			$subchannel = $obj["body"]["subchannel"];
			$sucursal = $obj["body"]["sucursal"];
			$web=$obj["body"]["web"];
			$adultos = $obj["body"]["adultos"];
			$menores = $obj["body"]["menores"];
			$ingreso = date('Y-m-d');
			$horaingreso = date('H:i');
			
			$query = Yii::app()->db2->createCommand("INSERT INTO comercialbase (vendedor,nombre, apellido, telefono, mail, fecha,
				noches, categoriahotel, hotelpref, producto,formapago,comentarios,sucursal,adultos,menores,ingreso,estado,fuente,
				sitio, horaingreso,web)
			VALUES ( '$username','$nombre', '$apellido', '$numero', '$mail', '$fecha', '$noches', '$categoriahotel', '$hotel',
				'$producto','$formapago','$comments','$sucursal','$adultos','$menores','$ingreso',1,'$url','$subchannel', '$horaingreso','$web')")->query();
				//print_r('inserte');
			$id=Yii::app()->db2->lastInsertID;
			if (!empty($id))
				{return $id;}
	}

	public function getMarckupConfig($producto,$subchannel,$channel){

		if(strtolower($subchannel)=='all'){
				$subQuery = "";
			}else{
				$subQuery = "AND subchannels.title = '$subchannel'";
			}
			if(strtolower($channel)=='all'){
				$chnQuery = "";
			}else{
				$chnQuery = " AND channels.title = '$channel' ";
			}

		$query = Yii::app()->db->createCommand("SELECT providers.id as id_proveedor,marckup_config.enabled,providers.title AS Proveedor,marckup_concept.title,marckup_concept.id as id_marckup,marckup_config.marckup_percentage FROM marckup_config
				LEFT JOIN channels ON marckup_config.id_channel = channels.id
				LEFT JOIN subchannels ON marckup_config.id_subchannel = subchannels.id
				INNER JOIN products ON marckup_config.id_product = products.id
				LEFT JOIN providers ON marckup_config.id_provider = providers.id
				LEFT JOIN marckup_concept ON marckup_config.id_marckup_concept =marckup_concept.id
				WHERE marckup_config.enabled = 1 and products.title='$producto' $subQuery $chnQuery")->queryAll();

		return $query;
	}

	public function getFinancialCost($producto){
		$query = Yii::app()->db->createCommand("SELECT DISTINCT percentage_financial_cost,id_provider as id_proveedor FROM financial_cost where id_product in (SELECT id FROM products where title = '$producto')")->query();
		return $query;
	}

	public function getExchange(){
		$query=Yii::app()->db->createCommand("SELECT * FROM  currency ORDER BY id DESC LIMIT 1")->queryrow();
		return $query;
	}


	/**
	 * @api {get} /api/getpaymentrules/:literal Obtener los datos del flujo de financacion
	 * @apiName Getpaymentrules
	 * @apiGroup Metodos de pago
	 *
	 *
	 * @apiParam {String} literal Nombre de los metodos a consultar separados por comas ejemplo (payment,financing,exchange,marckup) si son todos colocar all
	 *
	 * @apiHeader {String} Channel Site
	 * @apiHeader {String} SubChannel URL o literal del sitio, ejemplo: http://www.ttsviajes.com o tts
	 * @apiHeader {String} Consumer iframe o api
	 * @apiHeader {String} Apikey codigo md5 generado por sam/login, ejemplo: 4a7cce094e4117a711326b63e3e8dfdd
	 * @apiHeader {String} Product Producto, ejemplo Paquetes
	 * @apiHeader {String} Provider Proveedor, puede ser null o el literal del proveedor
	 *
	 * @apiSuccessExample {json} Success-Response:
	 *
	 * {"marckup":[{"id_proveedor":"1","enabled":"1","Proveedor":"OLA","title":"Total A Cobrar Neto","id_marckup":"3","marckup_percentage":"2.00"},{"id_proveedor":"1","enabled":"1","Proveedor":"OLA","title":"Comisionable","id_marckup":"2","marckup_percentage":"2.00"},{"id_proveedor":"1","enabled":"1","Proveedor":"OLA","title":"Total A Cobrar Neto","id_marckup":"3","marckup_percentage":"2.00"},{"id_proveedor":"2","enabled":"1","Proveedor":"EuroVips","title":"Total a Cobrar","id_marckup":"1","marckup_percentage":"2.00"},{"id_proveedor":"2","enabled":"1","Proveedor":"EuroVips","title":"Comisionable","id_marckup":"2","marckup_percentage":"2.00"},{"id_proveedor":"2","enabled":"1","Proveedor":"EuroVips","title":"Total A Cobrar Neto","id_marckup":"3","marckup_percentage":"2.00"}],"financialcost":[{"percentage_financial_cost":"6.00","id_proveedor":"1"},{"percentage_financial_cost":"6.00","id_proveedor":"2"},{"percentage_financial_cost":"6.00","id_proveedor":"4"}],"exchange":{"id":"1170","usd":"15.30","enabled":"1","date":"2016-10-25","usdf":"15.60","bsp":"15.30","eur":"1.14","gbp":"1.29"},"rewards":[],"paymentMethod":[{"entity":"BANCO HIPOTECARIO","credit_cards":[{"credit_card":"Visa","paymentMethod":[{"dues":"6","interest":"0","cftn":"0","posnet_cost":"0"}]}]},{"entity":"BANCO INDUSTRIAL","credit_cards":[{"credit_card":"Visa","paymentMethod":[{"dues":"6","interest":"0","cftn":"0","posnet_cost":"0"}]},{"credit_card":"MasterCard","paymentMethod":[{"dues":"6","interest":"0","cftn":"0","posnet_cost":"0"}]}]},{"entity":"BANCO PATAGONIA","credit_cards":[{"credit_card":"Visa","paymentMethod":[{"dues":"6","interest":"0","cftn":"0","posnet_cost":"0"}]},{"credit_card":"MasterCard","paymentMethod":[{"dues":"6","interest":"0","cftn":"0","posnet_cost":"0"}]},{"credit_card":"American Express","paymentMethod":[{"dues":"6","interest":"0","cftn":"0","posnet_cost":"0"}]}]},{"entity":"BANCO SUPERVIELLE","credit_cards":[{"credit_card":"Visa","paymentMethod":[{"dues":"6","interest":"0","cftn":"0","posnet_cost":"0"}]},{"credit_card":"MasterCard","paymentMethod":[{"dues":"6","interest":"0","cftn":"0","posnet_cost":"0"}]}]},{"entity":"CITI BANK","credit_cards":[{"credit_card":"Visa","paymentMethod":[{"dues":"6","interest":"0","cftn":"0","posnet_cost":"0"}]},{"credit_card":"MasterCard","paymentMethod":[{"dues":"6","interest":"0","cftn":"0","posnet_cost":"0"}]}]},{"entity":"HSBC","credit_cards":[{"credit_card":"Visa","paymentMethod":[{"dues":"12","interest":"0","cftn":"0","posnet_cost":"0"},{"dues":"15","interest":"0","cftn":"0","posnet_cost":"0"}]},{"credit_card":"MasterCard","paymentMethod":[{"dues":"12","interest":"0","cftn":"0","posnet_cost":"0"},{"dues":"15","interest":"0","cftn":"0","posnet_cost":"0"}]},{"credit_card":"American Express","paymentMethod":[{"dues":"12","interest":"0","cftn":"0","posnet_cost":"0"}]}]},{"entity":"MASTERCARD","credit_cards":[]}]}
	 */
	public function actionGetpaymentrules($literal){
			header('Content-type: application/json');
			if($this->setValidate($_SERVER['HTTP_CHANNEL'],$_SERVER['HTTP_SUBCHANNEL'],$_SERVER['HTTP_CONSUMER'])){
				if(isset($_SERVER['HTTP_PRODUCT']) ){

					$subchannel=$this->setSubchannelTitle($_SERVER['HTTP_CONSUMER'],$_SERVER['HTTP_SUBCHANNEL']);

					$provider = $_SERVER['HTTP_PROVIDER'];
					$product = $_SERVER['HTTP_PRODUCT'];
					if(empty($_SERVER['HTTP_CHANNEL'])){
						$channel = 'Site';
					}else{
						$channel = $_SERVER['HTTP_CHANNEL'];
					}
					if(empty($_SERVER['HTTP_REWARDS'])){
						$rewards = 0;
						$financiacionRewards = array();
					}else{
						$rewards = $_SERVER['HTTP_REWARDS'];
						$financiacionRewards = $this->getRewards($product,$channel,$subchannel,$_SERVER['HTTP_CONSUMER']);
					}

					$busqueda = explode(',',$literal);
					$payment = array();
					$financing = array();
					$marckup = array();
					$exchange = array();
					$final = array();
					for ($i=0; $i <sizeof($busqueda) ; $i++) {

						switch ($busqueda[$i]) {
							case 'payment':
								$payment = $this->getPayment($subchannel,$product,$provider,$rewards);
							break;
							case 'financing':
								$financianQuery = $this->getFinancialCost($product);
								$financianQuery = CJSON::encode($financianQuery);
								$financing = json_decode($financianQuery,true);
							break;
							case 'exchange':
								$exchengeQuery = $this->getExchange();
								$exchange = $exchengeQuery;
							break;
							case 'marckup':
								$marckUpQuery=$this->getMarckupConfig($product,$subchannel,$channel);
								$marckUpQuery = CJSON::encode($marckUpQuery);
								$marckup = json_decode($marckUpQuery,true);
							break;

							default:
								$payment = $this->getPayment($subchannel,$product,$provider,$rewards);
								$financianQuery = $this->getFinancialCost($product);
								$financianQuery = CJSON::encode($financianQuery);
								$financing = json_decode($financianQuery,true);
								$exchengeQuery = $this->getExchange();
								$exchange = $exchengeQuery;
								$marckUpQuery=$this->getMarckupConfig($product,$subchannel,$channel);
								$marckUpQuery = CJSON::encode($marckUpQuery);
								$marckup = json_decode($marckUpQuery,true);
							break;
						}

	    			$final['marckup'] = $marckup;
			      $final['financialcost'] = $financing;
						$final['exchange'] = $exchange;
						$final['rewards'] = $financiacionRewards;
			      $final['paymentMethod'] = $payment;
					}
				}
	    echo json_encode($final);
	  }
	}

	public function getPayment($subchannel,$product,$provider,$rewards){


		if($provider == 'null'){
			$providerQuery = "and provider is null";
		}else{
			$providerQuery = "and (provider = '$provider' or provider is NULL)";
		}

		if($subchannel != 'tts'){
			$query1 = Yii::app()->db->createCommand("SELECT distinct entity FROM financing WHERE (product = '$product' or product is NULL) and (subchannel_father = '$subchannel' or subchannel_son = '$subchannel') and CURDATE() >= date_validity_start and CURDATE() <= date_validity_end  $providerQuery and (rewards = $rewards or rewards is null);")->query();
		}else{
			$query1 = Yii::app()->db->createCommand("SELECT distinct entity FROM financing WHERE (product = '$product' or product is NULL) $providerQuery and (rewards = $rewards or rewards is null);")->query();
		}


		$entity = CJSON::encode($query1);
		$entity = json_decode($entity,true);
		
		if(empty($entity)){
			$query1 = Yii::app()->db->createCommand("SELECT distinct entity FROM financing WHERE (product = '$product' or product is NULL) $providerQuery and (rewards = $rewards or rewards is null);")->query();
			$entity = CJSON::encode($query1);
			$entity = json_decode($entity,true);

		}
		foreach ($entity as $key => $value) {
			$entidad = $value['entity'];
			$query2 = Yii::app()->db->createCommand("SELECT distinct credit_cards as credit_card FROM financing WHERE entity ='$entidad' and (product = '$product' or product is NULL) and CURDATE() >= date_validity_start and CURDATE() <= date_validity_end $providerQuery and (rewards = $rewards or rewards is null);")->query();
			$card = CJSON::encode($query2);
			$card = json_decode($card,true);
			//$entity[$key]['financial_cost'] = $financing[0]['percentage_financial_cost'];
			//$entity[$key]['marckup'] = $marckup[0]['marckup_percentage'];
			$entity[$key]['credit_cards'] = $card;
			foreach ($card as $c => $cards) {
				$tdc = $cards['credit_card'];
				$query2 = Yii::app()->db->createCommand("SELECT distinct dues,interest,cftn,posnet_cost,account_type,segment FROM financing WHERE entity ='$entidad' and credit_cards = '$tdc' and (product = '$product' or product is NULL) and CURDATE() >= date_validity_start and CURDATE() <= date_validity_end $providerQuery and (rewards = $rewards or rewards is null);")->query();
				$payment = CJSON::encode($query2);
				$payment = json_decode($payment,true);
				$entity[$key]['credit_cards'][$c]['paymentMethod'] = $payment;
			}
		}
		return $entity;
	}

	public function actionGetpaymentbeta(){
		header('Content-type: application/json');
		if(isset($_SERVER['HTTP_PRODUCT']) ){

			if(isset($_SERVER['HTTP_CONSUMER']) && strtolower($_SERVER['HTTP_CONSUMER']) == 'iframe'){
				$subchannel = strtolower(json_decode(self::getSubchannelTitle($_SERVER['HTTP_SUBCHANNEL']))
				->subchannel);
			}else{
				$subchannel = strtolower($_SERVER['HTTP_SUBCHANNEL']);
			}
			$provider = isset($_SERVER['HTTP_PROVIDER']) ? $_SERVER['HTTP_PROVIDER']: null;
			$product = $_SERVER['HTTP_PRODUCT'];
			if(empty($_SERVER['HTTP_CHANNEL'])){
				$channel = 'Site';
			}else{
				$channel = $_SERVER['HTTP_CHANNEL'];
			}
			if(empty($_SERVER['HTTP_REWARDS'])){
				$rewards = 0;
				$financiacionRewards = array();
			}else{
				$rewards = $_SERVER['HTTP_REWARDS'];
				$financiacionRewards = $this->getRewards($product,$channel,$subchannel,$_SERVER['HTTP_CONSUMER']);
			}

			$financianQuery = Yii::app()->db->createCommand("SELECT DISTINCT percentage_financial_cost,id_provider as id_proveedor FROM financial_cost where id_product in (SELECT id FROM products where title = '$product')")->query();
			$financianQuery = CJSON::encode($financianQuery);
			$financing = json_decode($financianQuery,true);

			$marckUpQuery=Yii::app()->db->createCommand("SELECT providers.id as id_proveedor,marckup_config.enabled,providers.title AS Proveedor,marckup_concept.title,marckup_concept.id as id_marckup,marckup_config.marckup_percentage FROM marckup_config
			LEFT JOIN channels ON marckup_config.id_channel = channels.id
			LEFT JOIN subchannels ON marckup_config.id_subchannel = subchannels.id
			INNER JOIN products ON marckup_config.id_product = products.id
			LEFT JOIN providers ON marckup_config.id_provider = providers.id
			LEFT JOIN marckup_concept ON marckup_config.id_marckup_concept =marckup_concept.id
			WHERE marckup_config.enabled = 1 and products.title='$product'")->queryAll();

			$marckUpQuery = CJSON::encode($marckUpQuery);
			$marckup = json_decode($marckUpQuery,true);
			if($provider == 'null'){
				$providerQuery = "and provider is null";
			}else{
				$providerQuery = "and (provider = '$provider' or provider is NULL)";
			}
			/*
			if($subchannel != 'tts'){
  			$query1 = Yii::app()->db->createCommand("SELECT distinct entity FROM financing WHERE (product = '$product' or product is NULL) and (subchannel_father = '$subchannel' or subchannel_son = '$subchannel') and CURDATE() >= date_validity_start and CURDATE() <= date_validity_end  $providerQuery and (rewards = $rewards or rewards is null);")->query();
    	}else{
     		$query1 = Yii::app()->db->createCommand("SELECT distinct entity FROM financing WHERE (product = '$product' or product is NULL) $providerQuery and (rewards = $rewards or rewards is null);")->query();
    	}
			*/
			//FILTER BY SUBCHANNEL_ENTITY

    	$subchannel_entity_query = "SELECT distinct title from subchannels s  inner join subchannels_entity se on se.id_subchannel = s.id where s.title = '$subchannel'";

			$allow_entity_result = Yii::app()->db->createCommand($subchannel_entity_query)->query();

			if(count($allow_entity_result)>0){
				$query1 = Yii::app()->db->createCommand("SELECT distinct entity FROM financing WHERE (product = '$product' or product is NULL) and  subchannel_son = '$subchannel' and CURDATE() >= date_validity_start and CURDATE() <= date_validity_end $providerQuery and (rewards = $rewards or rewards is null);")->query();
			} else {
				$query1 = Yii::app()->db->createCommand("SELECT distinct entity FROM financing WHERE (product = '$product' or product is NULL) and CURDATE() >= date_validity_start and CURDATE() <= date_validity_end $providerQuery and (rewards = $rewards or rewards is null);")->query();
			}

    	$entity = CJSON::encode($query1);
			$entity = json_decode($entity,true);

    	//FILTER BY SUBCHANNEL_CREDIT_CARDS
    	$filter_by_subchannel_credit_card = false;
    	$subchannel_cc_query = "SELECT cc.name FROM subchannels s INNER JOIN subchannels_credit_cards scc ON s.id = scc.id_subchannel INNER JOIN credit_cards cc ON scc.id_creditcard = cc.id WHERE s.title = '$subchannel'";
			$allow_cc_result = Yii::app()->db->createCommand($subchannel_cc_query)->query();
			if(count($allow_cc_result)>0){
				$filter_by_subchannel_credit_card = true;
				$allow_cc = CJSON::encode($allow_cc_result);
				$allow_cc = json_decode($allow_cc,true);
				$in_fields = "";
				foreach ($allow_cc as $key => $cc) {
					$in_fields = $in_fields == "" ? "'" . $cc['name'] ."'" : $in_fields . "," . "'" . $cc['name'] . "'";
				}
			}

			foreach ($entity as $key => $value) {
				$entidad = $value['entity'];
				if ($filter_by_subchannel_credit_card) {
					$query2 = Yii::app()->db->createCommand("SELECT distinct credit_cards as credit_card FROM financing WHERE entity ='$entidad' and credit_cards IN ($in_fields) and (product = '$product' or product is NULL) and CURDATE() >= date_validity_start and CURDATE() <= date_validity_end $providerQuery and (rewards = $rewards or rewards is null);")->query();
				} else {
					$query2 = Yii::app()->db->createCommand("SELECT distinct credit_cards as credit_card FROM financing WHERE entity ='$entidad' and (product = '$product' or product is NULL) and CURDATE() >= date_validity_start and CURDATE() <= date_validity_end $providerQuery and (rewards = $rewards or rewards is null)")->query();
				}

				$card = CJSON::encode($query2);
				$card = json_decode($card,true);
				//$entity[$key]['financial_cost'] = $financing[0]['percentage_financial_cost'];
				//$entity[$key]['marckup'] = $marckup[0]['marckup_percentage'];
				$entity[$key]['credit_cards'] = $card;
				foreach ($card as $c => $cards) {
					$tdc = $cards['credit_card'];
					$query2 = Yii::app()->db->createCommand("SELECT distinct dues,interest,cftn,posnet_cost FROM financing WHERE entity ='$entidad' and credit_cards = '$tdc' and (product = '$product' or product is NULL) and CURDATE() >= date_validity_start and CURDATE() <= date_validity_end $providerQuery and (rewards = $rewards or rewards is null);")->query();
					$payment = CJSON::encode($query2);
					$payment = json_decode($payment,true);
					$entity[$key]['credit_cards'][$c]['paymentMethod'] = $payment;
				}
			}

      $final['marckup'] = $marckup;
      $final['financialcost'] = $financing;
			$final['rewards'] = $financiacionRewards;
      $final['paymentMethod'] = $entity;

    	echo json_encode($final);
  	}
	}

	public function actionGetMaxCuotas(){
		set_time_limit(0);
		header('Content-type: application/json');
	  $product = "SELECT distinct title FROM products";
	  $product = Yii::app()->db->createCommand($product)->query();
	  $product = CJSON::encode($product);
	  $product = json_decode($product,true);

	  $subQuery = "SELECT distinct title, reward  from subchannels where enabled = 1 and id_channel = 9";
	  $subQuery = Yii::app()->db->createCommand($subQuery)->query();
	  $subcanales = CJSON::encode($subQuery);
	  $subcanales = json_decode($subcanales,true);
	  $subchannels = array();
	  foreach ($subcanales as $key => $value) {
	    array_push($subchannels,$subcanales[$key]);
	  }

	  $providers = array();
	  $providerQuery = "SELECT entity, subchannel_son, product, provider, MAX( dues ) as maxdues FROM  `financing` 
											WHERE provider IS NOT NULL 
											GROUP BY subchannel_son, provider";
	  $providerQuery = Yii::app()->db->createCommand($providerQuery)->query();
	  $providerMaxDues = $providerQuery;

	  foreach ($providerMaxDues as $key => $items) {
	  	$providers[$items['subchannel_son']][$items['product']][$items['provider']]['maxdues'] = $items['maxdues'];
	  }

	  $max_cuotas = array();
	  foreach ($subchannels as $key => $value) {
	    $title = $value['title'];
	    $reward = $value['reward'];

	    foreach ($product as $p => $productos) {
	      $producto = $productos['title'];

				if($reward  == 1){
					$cuotaQuery  =  Yii::app()->db->createCommand("SELECT max(dues) as max_cuota
		                      from financing
		                      where CURDATE() >= date_validity_start and CURDATE() <= date_validity_end
		                      and subchannel_son = '$title'
		                      and (product = '$producto' or product is NULL)
		                      and provider is NULL
													and (rewards = 1)")->queryAll();

					$cuotaQueryVacia  =  Yii::app()->db->createCommand("SELECT max(dues) as max_cuota
				                      from financing
				                      where CURDATE() >= date_validity_start and CURDATE() <= date_validity_end
				                      and (subchannel_son is null or subchannel_father is null)
				                      and (product = '$producto' or product is NULL)
				                      and provider is NULL
															and (rewards = 1)")->queryAll();
				}else{
					$cuotaQuery  =  Yii::app()->db->createCommand("SELECT max(dues) as max_cuota
		                      from financing
		                      where CURDATE() >= date_validity_start and CURDATE() <= date_validity_end
		                      and subchannel_son = '$title'
		                      and (product = '$producto' or product is NULL)
		                      and provider is NULL
													and (rewards = 0 or rewards is null)")->queryAll();

					$cuotaQueryVacia  =  Yii::app()->db->createCommand("SELECT max(dues) as max_cuota
				                      from financing
				                      where CURDATE() >= date_validity_start and CURDATE() <= date_validity_end
				                      and (subchannel_son is null or subchannel_father is null)
				                      and (product = '$producto' or product is NULL)
				                      and provider is NULL
															and (rewards = 0 or rewards is null)")->queryAll();

				}

	      $cuota = CJSON::encode($cuotaQuery);
	      $cuota = json_decode($cuota,true);
				$cuotaVacia = CJSON::encode($cuotaQueryVacia);
	      $cuotaVacia = json_decode($cuotaVacia,true);
				if(!empty($cuota[0]['max_cuota'])){
					$max_cuotas[$key]['subchannel'] = $value['title'];
					$max_cuotas[$key]['products'][$p]['title'] = $producto;
					$max_cuotas[$key]['products'][$p]['max_dues'] = $cuota[0]['max_cuota'];

				}else{
					  if ($cuotaVacia[0]['max_cuota']==NULL || empty($cuotaVacia[0]['max_cuota']) || !isset($cuotaVacia[0]['max_cuota']) || $cuotaVacia[0]['max_cuota']=="")
                    {$cuotaVacia[0]['max_cuota']='1';}
					$max_cuotas[$key]['subchannel'] = $value['title'];
					$max_cuotas[$key]['products'][$p]['title'] = $producto;
					$max_cuotas[$key]['products'][$p]['max_dues'] = $cuotaVacia[0]['max_cuota'];
				}
				if (!empty($providers[$title])) {
					if (!empty($providers[$title][$producto])) {
						if (!empty($providers[$title][$producto])) {
							$max_cuotas[$key]['products'][$p][key($providers[$title][$producto])] = $providers[$title][$producto][key($providers[$title][$producto])];
						}
					}
				}
	    }
	  }
		$max_cuotas = array_values($max_cuotas);
	  $max_cuotas = json_encode($max_cuotas);
	  echo $max_cuotas;
	}


	public function getRewards($producto, $canal, $subcanal, $consumer){
		if(strtolower($consumer) == 'api'){
			$query  =  Yii::app()->db->createCommand("SELECT rewards_date_from,rewards_date_to,rewards_conversion_ratio,
													rewards_conversion_min,rewards_conversion_max,rewards_multiple_logic
													from offers_product op
													join subchannels s on s.id = op.id_subchannel
													join products p on p.id = op.id_product
													join channels c on c.id = s.id_channel
													where p.title = '$producto' and s.title = '$subcanal' and c.title = '$canal'
													and CURDATE() >= rewards_date_from and CURDATE() <= rewards_date_to
													limit 1")->query();
			$query = CJSON::encode($query);
			$query = json_decode($query,true);
		}else{
			$query  =  Yii::app()->db->createCommand("SELECT rewards_date_from,rewards_date_to,rewards_conversion_ratio,
													rewards_conversion_min,rewards_conversion_max,rewards_multiple_logic
													from search op
													join subchannels s on s.id = op.id_subchannel
													join products p on p.id = op.id_product
													join channels c on c.id = s.id_channel
													where p.title = '$producto' and s.title = '$subcanal' and c.title = '$canal'
													and CURDATE() >= rewards_date_from and CURDATE() <= rewards_date_to
													limit 1")->query();
			$query = CJSON::encode($query);
			$query = json_decode($query,true);
		}
		return $query;
	}


	public function actionGetsubchannel(){
		header('Content-type: application/json');
		if(isset($_SERVER['HTTP_SUBCHANNEL'])){
			$subchannel=$_SERVER['HTTP_SUBCHANNEL'];
			try{
				echo self::getSubchannelTitle($subchannel);
			}catch(Exception $ex){
				throw new CHttpException(404,1);
			}
		}else{
			throw new CHttpException(404,0);
		}
		Yii::app()->end();
	}

	public function getSubchannelTitle($subchannel_url){

		$query=Yii::app()->db->createCommand("SELECT title as subchannel,reward	FROM subchannels WHERE url LIKE '%$subchannel_url%' limit 1")->queryRow();
		if(count($query)>0){
			return CJSON::encode($query);
		}else{
			throw new CHttpException(404,1);
		}
	}


	/**
	 * @api {get} /api/Getsubchannelsbyproduc/:producto Obtener subchannels por producto

	 * @apiName Subchannels por producto
	 * @apiGroup Subchannels por producto
	 *
	 * @apiParam {String} producto Producto
	 *
	 * @apiHeader {String} Apikey XXXX
	 *
	 * @apiSuccessExample {json} Success-Response:
	 *
	 *
		[
		 {
		   "channel": "9",
		   "children_subchannel_folder": "HSBC",
		   "children_subchannel": "2",
		   "channel_folder": "Site",
		   "subchannel": "2",
		   "subchannel_folder": "HSBC",
		   "subchannel_url": "http://hsbc.ttsviajes.com/"
		 },
		 {
		   "channel": "9",
		   "children_subchannel_folder": "HSBC",
		   "children_subchannel": "2",
		   "channel_folder": "Site",
		   "subchannel": "3",
		   "subchannel_folder": "HSBCPremier",
		   "subchannel_url": "http://hsbc.ttsviajes.com/premier/"
		 },
		 {
		   "channel": "9",
		   "children_subchannel_folder": "TTS",
		   "children_subchannel": "100",
		   "channel_folder": "Site",
		   "subchannel": "100",
		   "subchannel_folder": "TTS",
		   "subchannel_url": "http://www.ttsviajes.com/"
		 }
		]
	 */

	 public function actionGetsubchannelsbyproduct($producto){
 		header('Content-type: application/json');
 			if(self::_validarapi_key($_SERVER['HTTP_APIKEY'])){
 				$query=Yii::app()->db->createCommand("
 					SELECT
 					    ch.id channel,
 					    IF(ISNULL(sch.id_subchannel),
 					        sch.title,
 					        sch_chldr.title) children_subchannel_folder,
 					    IF(ISNULL(sch.id_subchannel),
 					        sch.id,
 					        sch_chldr.id) children_subchannel,
 					    ch.title channel_folder,
 					    sch.id subchannel,
 					    sch.title subchannel_folder,
 					    sch.url subchannel_url
 					FROM search s
 			        LEFT JOIN channels ch ON ch.id = s.id_channel
 			        LEFT JOIN subchannels sch ON sch.id = s.id_subchannel
 			        LEFT JOIN products p ON p.id = s.id_product
 			        LEFT JOIN subchannels sch_chldr ON sch.id_subchannel = sch_chldr.id
 					WHERE p.title = '$producto'")->queryAll();
 				if(count($query)>0){
 					echo CJSON::encode($query);
 				}else{
 					throw new CHttpException(404,1);
 				}
 			}else{
 				throw new CHttpException(401,3);
 			}

 	}
	/**
	 * @api {get} /api/supportflowpackage/:producto/:literal Obtener los datos del flujo de paquetes
	 * @apiName Supportflowpackage
	 * @apiGroup Paquetes
	 *
	 * @apiParam {String} producto Nombre del producto
	 * @apiParam {String} literal Nombre de los metodos a consultar separados por comas ejemplo (rulesservices,adminrules,highlight) si son todos colocar all
	 *
	 * @apiHeader {String} Channel XXXX
	 * @apiHeader {String} SubChannel XXXX
	 * @apiHeader {String} Consumer XXXX
	 * @apiHeader {String} Apikey XXXX
	 *
	 * @apiSuccessExample {json} Success-Response:
	 *
	 * {"rules_services":[{"external_endpoint":"http://www-qa1.ola.com.ar/nuevo/wsola/endpoint","internal_endpoint":"http://10.85.253.150:8090/","enabled":"1","id_provider":"1","title":"OLA","client_user":"webtts","client_pass":"tts123tts","anticipation_from_min_days":"3","anticipation_to_max_days":"15","time_out":"480","time_out_msg":"Tiempo de sesión expirada","cache":"0","start_cache_days":null,"max_cache_days":null,"frequency":null,"start_time":null,"subchanneltitle":"TTS"},{"external_endpoint":"http://190.2.40.197:8083/WSBridge_Euro/BridgeService.asmx?wsdl","internal_endpoint":"http://dev.app.ttsviajes.com/","enabled":"0","id_provider":"2","title":"EuroVips","client_user":"TTSVIAJES","client_pass":"WS00815","anticipation_from_min_days":"3","anticipation_to_max_days":"15","time_out":"900","time_out_msg":"Tiempo de sesión expirada","cache":"0","start_cache_days":null,"max_cache_days":null,"frequency":null,"start_time":null,"subchanneltitle":"TTS"}],"admin_rules":[{"channel":"Site","subchannel":"TTS","product":"Paquetes","admin_notifications":{"admin_alert":{"alerts_server_name":"Servidor Principal","alerts_server_host":"181.119.20.114","alerts_server_port":"21","alerts_server_ssl":"0","alerts_user":"sendmail@ttsviajes.com","alerts_pass":"tts3563","alerts_show_as":"sendmail@ttsviajes.com","alerts_subject_patterns":"Channel | SubChannel | Producto: {Variable}","alerts_to":"pruebatesting@ttsviajes.com"},"admin_sale":{"sale_server_name":"Servidor Principal","sale_server_host":"181.119.20.114","sale_server_port":"21","sale_server_ssl":"0","sale_user":"sendmail@ttsviajes.com","sale_pass":"tts3563","sale_show_as":"sendmail@ttsviajes.com","sale_to":"pruebatesting@ttsviajes.com"}},"admin_landings":{"landings_order_price":"asc","landings_order_departure":"asc","landings_telephone_sales":null,"landings_max_results_per_pages":"5"}}],"highlight":[]}
	 */
	public function actionSupportflowpackage($producto,$literal){
		header('Content-type: application/json');
			if(self::_validarapi_key($_SERVER['HTTP_APIKEY'])){
		
				if(isset($producto) and $this->setValidate($_SERVER['HTTP_CHANNEL'],$_SERVER['HTTP_SUBCHANNEL'],$_SERVER['HTTP_CONSUMER'])){

						if(strtolower($_SERVER['HTTP_SUBCHANNEL'])=='all'){
							$subchannelTitle='all';
						}else{
							$subchannelTitle=$this->setSubchannelTitle($_SERVER['HTTP_CONSUMER'],$_SERVER['HTTP_SUBCHANNEL']);
						}


						$busqueda = explode(',',$literal);
						$query1 = array();
						$query2 = array();
						$query3 = array();
						$all = array();
						for ($i=0; $i <sizeof($busqueda) ; $i++) {
							switch ($busqueda[$i]) {

								case 'rulesservices':
									$query1 = $this->getRulesServices($_SERVER['HTTP_CHANNEL'], $subchannelTitle, $_SERVER['HTTP_CONSUMER'], $producto);

									break;

								case 'adminrules':
									$query2 = $this->getAdminRules($_SERVER['HTTP_CHANNEL'], $subchannelTitle, $_SERVER['HTTP_CONSUMER'], $producto);

									break;

								case 'highlight':
									$query3 = $this->getHighlights($_SERVER['HTTP_CHANNEL'], $subchannelTitle, $_SERVER['HTTP_CONSUMER'], $producto);

									break;


							}
						}
						$all['rules_services'] = $query1;
						$all['admin_rules'] = $query2;
						$all['highlight'] = $query3;

						if($literal=='all'){
							$query1 = $this->getRulesServices($_SERVER['HTTP_CHANNEL'], $subchannelTitle, $_SERVER['HTTP_CONSUMER'], $producto);
							$query2 = $this->getAdminRules($_SERVER['HTTP_CHANNEL'], $subchannelTitle, $_SERVER['HTTP_CONSUMER'], $producto);
							$query3 = $this->getHighlights($_SERVER['HTTP_CHANNEL'], $subchannelTitle, $_SERVER['HTTP_CONSUMER'], $producto);

							$all['rules_services'] = $query1;
							$all['admin_rules'] = $query2;
							$all['highlight'] = $query3;
						}

						echo json_encode($all);

				}else{
					throw new CHttpException(404,1);
				}
			}else{
				throw new CHttpException(404,0);
			}

	}


	public function getAdminRules($channel,$subchannel,$consumer,$producto){
		if(strtolower($subchannel)=='all'){
			$subQuery = "";
		}else{
			$subQuery = "AND subchannels.title = '$subchannel'";
		}

		if(strtolower($channel)=='all'){
			$chnQuery = "";
		}else{
			$chnQuery = " AND channels.title = '$channel' ";
		}
		$query=Yii::app()->db->createCommand("
			SELECT
				search.id,
				channels.title channel,
				subchannels.title subchannel,
				products.title product,
				server_alert.title as alerts_server_name,
				server_alert.host_server_mail as alerts_server_host,
				server_alert.Port as alerts_server_port,
				server_alert.ssl as alerts_server_ssl,
				search.alerts_user,
				search.alerts_pass,
				search.alerts_show_as,
				search.alerts_subject_patterns,
				search.alerts_to,
				server_sales.title as sale_server_name,
				server_sales.host_server_mail as sale_server_host,
				server_sales.Port as sale_server_port,
				server_sales.ssl as sale_server_ssl,
				search.sale_user,
				search.sale_pass,
				search.sale_show_as,
				search.sale_to,
				search.landings_order_price AS landings_order_price,
				search.landings_order_departure AS landings_order_departure,
				search.landings_telephone_sales AS landings_telephone_sales,
				search.landings_max_results_per_pages AS landings_max_results_per_pages
			FROM search
			LEFT JOIN channels ON channels.id = search.id_channel
			LEFT JOIN subchannels ON subchannels.id = search.id_subchannel
			LEFT JOIN products ON products.id = search.id_product
			LEFT JOIN email_server as server_alert ON search.id_email_server_alerts = server_alert.id
			LEFT JOIN email_server as server_sales ON search.id_email_server_sales = server_sales.id
			WHERE search.enabled = 1
			AND server_alert.enabled = 1
			AND server_sales.enabled = 1
			AND products.title = '$producto'
			$chnQuery
			$subQuery")->queryAll();
		
		$admin_rules = [];
		$admin_rule = [];
		$admin_notifications = [];
		$admin_alert = [];
		$admin_sale = [];
		$admin_landings = [];
		$admin_facets = [];
		if(count($query)>0){
			foreach ($query as $key => $value) {
					$admin_rule['channel'] = $value['channel'];
					$admin_rule['subchannel'] = $value['subchannel'];
					$admin_rule['product'] = $value['product'];

					$admin_alert['alerts_server_name'] = $value['alerts_server_name'];
					$admin_alert['alerts_server_host'] = $value['alerts_server_host'];
					$admin_alert['alerts_server_port'] = $value['alerts_server_port'];
					$admin_alert['alerts_server_ssl'] = $value['alerts_server_ssl'];
					$admin_alert['alerts_user'] = $value['alerts_user'];
					$admin_alert['alerts_pass'] = $value['alerts_pass'];
					$admin_alert['alerts_show_as'] = $value['alerts_show_as'];
					$admin_alert['alerts_subject_patterns'] = $value['alerts_subject_patterns'];
					$admin_alert['alerts_to'] = $value['alerts_to'];

					$admin_sale['sale_server_name'] = $value['sale_server_name'];
					$admin_sale['sale_server_host'] = $value['sale_server_host'];
					$admin_sale['sale_server_port'] = $value['sale_server_port'];
					$admin_sale['sale_server_ssl'] = $value['sale_server_ssl'];
					$admin_sale['sale_user'] = $value['sale_user'];
					$admin_sale['sale_pass'] = $value['sale_pass'];
					$admin_sale['sale_show_as'] = $value['sale_show_as'];
					$admin_sale['sale_to'] = $value['sale_to'];

					$admin_landings['landings_order_price'] = $value['landings_order_price'];
					$admin_landings['landings_order_departure'] = $value['landings_order_departure'];
					$admin_landings['landings_telephone_sales'] = $value['landings_telephone_sales'];
					$admin_landings['landings_max_results_per_pages'] = $value['landings_max_results_per_pages'];

					$query_facets = Yii::app()->db->createCommand("SELECT fef.title, fef.is_facets
									FROM search_facets_extend_filters sfef
											LEFT JOIN facets_extended_filters fef ON sfef.id_facets = fef.id
											LEFT JOIN products ON fef.id_product = products.id
									WHERE sfef.id_search = ".$value['id']." AND sfef.enabled = 1 AND products.title ='".$producto."'")->queryAll();
					/*echo "SELECT fef.title, fef.is_facets
									FROM search_facets_extend_filters sfef
											LEFT JOIN facets_extended_filters fef ON sfef.id_facets = fef.id
											LEFT JOIN products ON fef.id_product = products.id
									WHERE sfef.id_search = ".$value['id']." AND sfef.enabled = 1 AND products.title ='".$producto."'";*/
					if(count($query_facets)>0){
						$admin_landings['facets'] = $query_facets;
					}

					$admin_notifications['admin_alert'] = $admin_alert;
					$admin_notifications['admin_sale'] = $admin_sale;
					$admin_rule['admin_notifications'] = $admin_notifications;
					$admin_rule['admin_landings'] = $admin_landings;
					array_push($admin_rules, $admin_rule);
			}
			return $admin_rules;
		}
	}

	public function getRulesServices($channel,$subchannel,$consumer,$producto){
		if(strtolower($subchannel)=='all'){
			$subQuery = "";
		}else{
			$subQuery = " AND subchannels.title = '$subchannel' ";
		}

		if(strtolower($channel)=='all'){
			$chnQuery = "";
		}else{
			$chnQuery = " AND channels.title = '$channel' ";
		}


		$query=Yii::app()->db->createCommand("
		SELECT 	rules_services.external_endpoint,
						rules_services.internal_endpoint,
								rules_services.enabled,
								rules_services.id_provider,
								providers.title,
								rules_services.client_user,
								rules_services.client_pass,
								rules_services.anticipation_from_min_days,
								rules_services.anticipation_to_max_days,
								rules_services.time_out,
								rules_services.time_out_msg,
								rules_services.cache,
								rules_services.start_cache_days,
								rules_services.max_cache_days,
								rules_services.cache_origins_destinations,
								rules_services.publish_cache_origins_destinations,
								rules_services.frequency,
								rules_services.start_time,
								rules_services.description,
						channels.id channel,
						if(isnull(subchannels.id_subchannel), subchannels.title, subchannels_chidren.title) children_subchannel_folder,
						if(isnull(subchannels.id_subchannel), subchannels.id, subchannels_chidren.id) children_subchannel,
						channels.title channel_folder,
						subchannels.id subchannel ,
						subchannels.title subchannel_folder,
						subchannels.url subchannel_url
				FROM rules_services
				INNER JOIN providers ON rules_services.id_provider = providers.id
				LEFT JOIN products ON rules_services.id_product = products.id
				LEFT JOIN channels ON rules_services.id_channel = channels.id
				LEFT JOIN subchannels ON rules_services.id_subchannel = subchannels.id
				LEFT JOIN subchannels subchannels_chidren ON subchannels.id_subchannel = subchannels_chidren.id
		WHERE products.title = '$producto'
		$chnQuery
		$subQuery")->queryAll();
		return $query;
	}

	public function getHighlights($channel,$subchannel,$consumer,$producto){
			if(strtolower($subchannel)=='all'){
				$subQuery = "";
			}else{
				$subQuery = "AND subchannels.title = '$subchannel'";
			}
			if(strtolower($channel)=='all'){
				$chnQuery = "";
			}else{
				$chnQuery = " AND channels.title = '$channel' ";
			}
			$final = array();
			$query=Yii::app()->db->createCommand("
				SELECT 	channels.title as channel,
						subchannels.title as subchannel,
						providers.title as proveedor,
						highlight_products.id_provider,
						products.title as producto,
								highlight_products.from_date as vigencia_desde,
								highlight_products.to_date as vigencia_hasta,
								highlight_products.title as titulo,
								highlight_products.highlight_static as estatico,
								highlight_products.highlight_dynamic as dinamico,
								highlight_products.ids_paquetes,
								highlights_criteria.title as criterio,
						highlight_products.highlight_order_criteria,
						highlight_products.Number_of_results as number_of_results,
						case highlight_products.offer
							when 1 then 'Oferta'
							when 0 then 'Destacado'
						end as tipo,
						highlight_products.order as highlight_order
				FROM highlight_products
				LEFT join providers on id_provider= providers.id
				LEFT join products on  products.id=id_product
				LEFT join highlights_criteria on highlights_criteria.id=id_highlights_criteria
				LEFT JOIN channels ON channels.id = highlight_products.id_channel
				LEFT JOIN subchannels ON subchannels.id = highlight_products.id_subchannel
				WHERE highlight_products.enabled = 1
				AND NOW() >= highlight_products.from_date
				AND NOW() <= highlight_products.to_date
				AND products.title = '$producto'
				$chnQuery
				$subQuery")->queryAll();

		if(count($query)>0){
			$final = [];
			foreach ($query as $key => $value) {
				$result = [];
				$estatico = [];
				$dinamico = [];
				$result['channel'] 			= $value['channel'];
				$result['subchannel'] 		= $value['subchannel'];
				$result['id_provider'] 		= $value['id_provider'];
				$result['proveedor'] 		= $value['proveedor'];
				$result['producto'] 		= $value['producto'];
				$result['vigencia_desde'] 	= $value['vigencia_desde'];
				$result['vigencia_hasta'] 	= $value['vigencia_hasta'];
				$result['titulo'] 			= $value['titulo'];
				if($value['estatico'] == 1){
					$estatico['id'] = explode('|', $value['ids_paquetes']);
					$estatico['tipo'] = $value['tipo'];
					$result['estatico'] = $estatico;
				}
				if($value['dinamico'] == 1){
					$dinamico['criterio'] = $value['criterio'];
					$dinamico['criterio_orden'] = $value['highlight_order_criteria'];
					$dinamico['cantidad_resultados'] = $value['number_of_results'];
					$dinamico['orden'] = $value['highlight_order'];
					$dinamico['tipo'] = $value['tipo'];
					$result['dinamico'] = $dinamico;
				}
				array_push($final, $result);
			}

		}

		return $final;
	}

	public function actionGetAdminrules($producto){
 		header('Content-type: application/json');
 		if(isset($_SERVER['HTTP_APIKEY'])){
 			if(self::_validarapi_key($_SERVER['HTTP_APIKEY'])){
 				if(isset($_SERVER['HTTP_CHANNEL']) && isset($_SERVER['HTTP_SUBCHANNEL']) && isset($_SERVER['HTTP_CONSUMER'])){
 					$channel=$_SERVER['HTTP_CHANNEL'];
 					$subchannel=$_SERVER['HTTP_SUBCHANNEL'];
 					$consumer=$_SERVER['HTTP_CONSUMER'];
 					$validate_consumer=self::consumer($consumer);
 					$query_add='';
 					/*$subchannelTitle = json_decode(self::getSubchannelTitle($_SERVER['HTTP_SUBCHANNEL']))
					->subchannel;*/
					$subchannelTitle = self::setSubchannelTitle($consumer,$subchannel);
 					$query=Yii::app()->db->createCommand("
 						SELECT
 							search.id,
 							channels.title channel,
 							subchannels.title subchannel,
 							products.title product,
 							server_alert.title as alerts_server_name,
 							server_alert.host_server_mail as alerts_server_host,
 							server_alert.Port as alerts_server_port,
 							server_alert.ssl as alerts_server_ssl,
 							search.alerts_user,
 							search.alerts_pass,
 							search.alerts_show_as,
 							search.alerts_subject_patterns,
 							search.alerts_to,
 							server_sales.title as sale_server_name,
 							server_sales.host_server_mail as sale_server_host,
 							server_sales.Port as sale_server_port,
 							server_sales.ssl as sale_server_ssl,
 							search.sale_user,
 							search.sale_pass,
 							search.sale_show_as,
 							search.sale_to,
 							search.landings_order_price AS landings_order_price,
 							search.landings_order_departure AS landings_order_departure,
 							search.landings_telephone_sales AS landings_telephone_sales,
 							search.landings_max_results_per_pages AS landings_max_results_per_pages
 						FROM search
 						LEFT JOIN channels ON channels.id = search.id_channel
 						LEFT JOIN subchannels ON subchannels.id = search.id_subchannel
 						LEFT JOIN products ON products.id = search.id_product
 						LEFT JOIN email_server as server_alert ON search.id_email_server_alerts = server_alert.id
 						LEFT JOIN email_server as server_sales ON search.id_email_server_sales = server_sales.id
 						WHERE search.enabled = 1
 						AND server_alert.enabled = 1
 						AND server_sales.enabled = 1
 						AND products.title = '$producto'
 						AND channels.title = '$channel'
 						AND subchannels.title LIKE '%$subchannelTitle%'")->queryAll();
 					
 					$admin_rules = [];
 					$admin_rule = [];
 					$admin_notifications = [];
 					$admin_alert = [];
 					$admin_sale = [];
 					$admin_landings = [];
 					$admin_facets = [];
 					if(count($query)>0){
 						foreach ($query as $key => $value) {
 								$admin_rule['channel'] = $value['channel'];
 								$admin_rule['subchannel'] = $value['subchannel'];
 								$admin_rule['product'] = $value['product'];

 								$admin_alert['alerts_server_name'] = $value['alerts_server_name'];
 								$admin_alert['alerts_server_host'] = $value['alerts_server_host'];
 								$admin_alert['alerts_server_port'] = $value['alerts_server_port'];
 								$admin_alert['alerts_server_ssl'] = $value['alerts_server_ssl'];
 								$admin_alert['alerts_user'] = $value['alerts_user'];
 								$admin_alert['alerts_pass'] = $value['alerts_pass'];
 								$admin_alert['alerts_show_as'] = $value['alerts_show_as'];
 								$admin_alert['alerts_subject_patterns'] = $value['alerts_subject_patterns'];
 								$admin_alert['alerts_to'] = $value['alerts_to'];

 								$admin_sale['sale_server_name'] = $value['sale_server_name'];
 								$admin_sale['sale_server_host'] = $value['sale_server_host'];
 								$admin_sale['sale_server_port'] = $value['sale_server_port'];
 								$admin_sale['sale_server_ssl'] = $value['sale_server_ssl'];
 								$admin_sale['sale_user'] = $value['sale_user'];
 								$admin_sale['sale_pass'] = $value['sale_pass'];
 								$admin_sale['sale_show_as'] = $value['sale_show_as'];
 								$admin_sale['sale_to'] = $value['sale_to'];

 								$admin_landings['landings_order_price'] = $value['landings_order_price'];
 								$admin_landings['landings_order_departure'] = $value['landings_order_departure'];
 								$admin_landings['landings_telephone_sales'] = $value['landings_telephone_sales'];
 								$admin_landings['landings_max_results_per_pages'] = $value['landings_max_results_per_pages'];

 								$query_facets = Yii::app()->db->createCommand("SELECT fef.title, fef.is_facets
 												FROM search_facets_extend_filters sfef
 										        LEFT JOIN facets_extended_filters fef ON sfef.id_facets = fef.id
 										        LEFT JOIN products ON fef.id_product = products.id
 												WHERE sfef.id_search = ".$value['id']." AND sfef.enabled = 1 AND products.title ='".$producto."'")->queryAll();
 								/*echo "SELECT fef.title, fef.is_facets
 												FROM search_facets_extend_filters sfef
 										        LEFT JOIN facets_extended_filters fef ON sfef.id_facets = fef.id
 										        LEFT JOIN products ON fef.id_product = products.id
 												WHERE sfef.id_search = ".$value['id']." AND sfef.enabled = 1 AND products.title ='".$producto."'";*/
 								if(count($query_facets)>0){
 									$admin_landings['facets'] = $query_facets;
 								}

 								$admin_notifications['admin_alert'] = $admin_alert;
 								$admin_notifications['admin_sale'] = $admin_sale;
 								$admin_rule['admin_notifications'] = $admin_notifications;
 								$admin_rule['admin_landings'] = $admin_landings;
 								array_push($admin_rules, $admin_rule);
 						}

 						echo CJSON::encode($admin_rules[0]);
 					}else{
 						throw new CHttpException(404,1);
 					}
 				}else{
 					throw new CHttpException(404,0);
 				}
 			}else{
 				throw new CHttpException(401,3);
 			}
 		}else{
 			throw new CHttpException(401,0);
 		}
 		Yii::app()->end();
 	}


public function actionRuncron(){
		$serverUrl='/home/ttsviajes/public_html/';
		// $serverUrl         = '/home/ttsviajes/public_html'; //parche
			$data = json_decode(file_get_contents('php://input'), true);
			if($data['usr']!=""){
					
				$resultado=shell_exec('/usr/local/bin/php -q '.$serverUrl .'/services/protected/yiic.php cronjob run');
				
				if($resultado==null){
					$err = array('msj'=>'El cron no puede mover los archivos porque se están realizando publicaciones. 5/5 intentos');
					print_r(json_encode($err));
				}else{
					echo $resultado;	
				}
				
			}else{
				$err = array('msj'=>'Error acceso');
				print_r(json_encode($err));
			}
		

}


public function actionResetcron(){
	$data = json_decode(file_get_contents('php://input'), true);
			if($data['usr']!=""){
					
		$recursivo=true;
		$directorio   = '/home/ttsviajes/public_html/services/tmp';
		$hola=$this->getObtenerCarpetas2($directorio);
        echo json_encode($hola);

        }else{
				$err = array('msj'=>'Error acceso');
				print_r(json_encode($err));
			}
}




public function actionGetcarpetas(){
		$recursivo=true;
		$directorio   = '/home/ttsviajes/public_html/services/tmp';
		$hola=$this->getObtenerCarpetas($directorio);
        echo json_encode($hola);	
}



 public function getObtenerCarpetas($dir)
    {
        
        $result = array();
        $cdir = scandir($dir);
        foreach ($cdir as $key => $value) {
            //la carpeta publish es la que contiene todos las publicaciones pasadas
            if (!in_array($value, array(
                ".",
                "..",
                'publish'
            ))) {
                if (is_dir($dir . DIRECTORY_SEPARATOR . $value)) {
                    $result[$value] = $this->getObtenerCarpetas($dir . DIRECTORY_SEPARATOR . $value);
                } else {
                	$ext=explode('.', $value);
                	if ($ext[1]=="json"){
                  $result[] = 'appserver/'.$dir . '/' . $value;
                    }
                }
            }
        }

 $result3=array();
        $i=0;
       foreach ($result as $key => $value) {
       	if (is_array($value) && !empty($value))
       	{
       		foreach ($value as $k => $v) {
       			 if(isset($v) && !empty($v))
       			 {
                    $result3[]=$result[$key][$k];
       			 }
       		}
       	}
       }


        return $result;
    }





public function getObtenerCarpetas2($dir)
    {
        
        $result = array();
        $cdir = scandir($dir);
        foreach ($cdir as $key => $value) {
            //la carpeta publish es la que contiene todos las publicaciones pasadas
            if (!in_array($value, array(
                ".",
                "..",
                'publish'
            ))) {
                if (is_dir($dir . DIRECTORY_SEPARATOR . $value)) {
                    $result[] = $this->getObtenerCarpetas2($dir . DIRECTORY_SEPARATOR . $value);
                } else {
                	$ext=explode('.', $value);
                	if ($ext[1]=="json"){
                    $result[] = $dir . '/' . $value;
                    @unlink($dir . '/' . $value);
                    }
                }
            }
        }

 $result3=array();
        $i=0;
       foreach ($result as $key => $value) {
       	if (is_array($value) && !empty($value))
       	{
       		foreach ($value as $k => $v) {
       			 if(isset($v) && !empty($v))
       			 {
                    $result3[]=$result[$key][$k];
       			 }
       		}
       	}
       }


        return $result;
    }
















}